<?php
require_once '../../config/config.php';
require_once '../../config/auth.php';
require_once '../../config/database.php';
require_once '../../templates/header.php';
require_once '../../templates/sidebar.php';

$id = $_GET['id'] ?? 0;

// ambil data anggota
$stmt = $db->prepare("SELECT * FROM anggota WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$data = $result->fetch_assoc();

if (!$data) {
    echo "<p>Data anggota tidak ditemukan</p>";
    exit;
}
?>

<h2>Edit Anggota</h2>

<form action="../../process/anggota_process.php" method="POST">
    <input type="hidden" name="aksi" value="edit">
    <input type="hidden" name="id" value="<?= $data['id']; ?>">

    <div class="form-group">
        <label>No Anggota</label>
        <input type="text" name="no_anggota" value="<?= $data['no_anggota']; ?>" required>
    </div>

    <div class="form-group">
        <label>Nama Lengkap</label>
        <input type="text" name="nama" value="<?= $data['nama']; ?>" required>
    </div>

    <div class="form-group">
        <label>Alamat</label>
        <textarea name="alamat" required><?= $data['alamat']; ?></textarea>
    </div>

    <div class="form-group">
        <label>No HP</label>
        <input type="text" name="no_hp" value="<?= $data['no_hp']; ?>" required>
    </div>

    <button type="submit" class="btn btn-primary">Update</button>
    <a href="index.php" class="btn btn-danger">Batal</a>
</form>

<?php require_once '../../templates/footer.php'; ?>
